<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Default public homepage
$routes->get('/', 'Home::index');

// Authentication
$routes->get('login', 'AuthController::login');
$routes->post('login', 'AuthController::attemptLogin');
$routes->get('logout', 'AuthController::logout');

// Diagnostic route
$routes->get('debug/auth-valid-fields', 'AuthController::debugValidFields');

// Dashboard and modules (protected via filters in Shield)
$routes->get('dashboard', 'Dashboard::index', ['filter' => 'permission:dashboard.access']);
$routes->get('profile', 'Dashboard::index'); // placeholder for student profile
$routes->get('enrollment', 'Enrollment::index', ['filter' => 'permission:enrollment.registration']);
$routes->post('enrollment', 'Enrollment::save', ['filter' => 'permission:enrollment.registration']);
$routes->get('enrollment/print/(:segment)', 'Enrollment::print/$1', ['filter' => 'permission:enrollment.registration']);

// Applications module
$routes->get('applications', 'Applications::index', ['filter' => 'permission:enrollment.registration']);
$routes->get('applications/continue/(:num)', 'Applications::continue/$1', ['filter' => 'permission:enrollment.registration']);
$routes->post('applications/approve/(:num)', 'Applications::approve/$1', ['filter' => 'permission:enrollment.registration']);
$routes->post('applications/reject/(:num)', 'Applications::reject/$1', ['filter' => 'permission:enrollment.registration']);
$routes->post('applications/delete/(:num)', 'Applications::delete/$1', ['filter' => 'permission:enrollment.registration']);

$routes->get('payments', 'Payments::index', ['filter' => 'permission:payments.manage_receipts']);
$routes->post('payments', 'Payments::store', ['filter' => 'permission:payments.manage_receipts']);
$routes->get('payments/print/(:num)', 'Payments::print/$1', ['filter' => 'permission:payments.manage_receipts']);
$routes->get('payments/history', 'Payments::history', ['filter' => 'permission:payments.manage_receipts']);
$routes->get('payments/installments', 'Payments::installments', ['filter' => 'permission:payments.manage_receipts']);
$routes->get('payments/pending', 'Payments::pending', ['filter' => 'permission:payments.manage_receipts']);

// Public Apply routes
$routes->get('apply', 'Apply::index');
$routes->post('apply', 'Apply::submit');

// Settings: User management (admin-only)
$routes->group('settings', ['filter' => 'group:admin'], static function ($routes) {
    $routes->get('users', 'Settings\\UserController::index');
    $routes->get('users/create', 'Settings\\UserController::create');
    $routes->post('users/store', 'Settings\\UserController::store');
    $routes->get('users/edit/(:num)', 'Settings\\UserController::edit/$1');
    $routes->post('users/update/(:num)', 'Settings\\UserController::update/$1');
    $routes->post('users/deactivate/(:num)', 'Settings\\UserController::deactivate/$1');
    $routes->post('users/reset-password/(:num)', 'Settings\\UserController::resetPassword/$1');
    // Permissions management per user
    $routes->get('users/permissions/(:num)', 'Settings\\UserController::permissions/$1');
    $routes->post('users/permissions/(:num)', 'Settings\\UserController::savePermissions/$1');

    // VAT Settings
    $routes->get('vat', 'Settings\\VatController::index');
    $routes->post('vat', 'Settings\\VatController::store');
});

// Setup routes
$routes->group('setup', static function ($routes) {
    $routes->get('school-years', 'Setup\SchoolYearController::index', ['filter' => 'permission:setup.school_year']);
    $routes->post('school-years', 'Setup\SchoolYearController::store', ['filter' => 'permission:setup.school_year']);
    $routes->get('classes', 'Setup\ClassController::index', ['filter' => 'permission:setup.stage']);
    $routes->post('classes', 'Setup\ClassController::store', ['filter' => 'permission:setup.stage']);
    $routes->get('sections', 'Setup\SectionController::index', ['filter' => 'permission:setup.section']);
    $routes->post('sections', 'Setup\SectionController::store', ['filter' => 'permission:setup.section']);
    $routes->get('payment-types', 'Setup\PaymentTypeController::index', ['filter' => 'permission:setup.payment_type']);
    $routes->post('payment-types', 'Setup\PaymentTypeController::store', ['filter' => 'permission:setup.payment_type']);
    $routes->get('nationalities', 'Setup\NationalityController::index', ['filter' => 'permission:setup.nationality']);
    $routes->post('nationalities', 'Setup\NationalityController::store', ['filter' => 'permission:setup.nationality']);
    $routes->get('religions', 'Setup\ReligionController::index', ['filter' => 'permission:setup.religion']);
    $routes->post('religions', 'Setup\ReligionController::store', ['filter' => 'permission:setup.religion']);
});

// Students list and print
$routes->get('students', 'Students::index');
$routes->get('students/print', 'Students::print');
$routes->get('students/profile/(:num)', 'Students::profile/$1');
$routes->get('students/ledger/(:num)', 'Students::ledger/$1');
$routes->post('students/update/(:num)', 'Students::update/$1');
$routes->post('students/delete/(:num)', 'Students::delete/$1');

// Photo serving
$routes->get('photos/(:segment)', 'Photos::serve/$1');
$routes->group('accounting', static function ($routes) {
    $routes->get('accounts', 'Accounting\\ChartOfAccounts::index', ['filter' => 'permission:accounting.chart_of_accounts']);
    $routes->get('accounts/create', 'Accounting\\ChartOfAccounts::create', ['filter' => 'permission:accounting.chart_of_accounts']);
    $routes->post('accounts/store', 'Accounting\\ChartOfAccounts::store', ['filter' => 'permission:accounting.chart_of_accounts']);
    $routes->get('accounts/edit/(:num)', 'Accounting\\ChartOfAccounts::edit/$1', ['filter' => 'permission:accounting.chart_of_accounts']);
    $routes->post('accounts/update/(:num)', 'Accounting\\ChartOfAccounts::update/$1', ['filter' => 'permission:accounting.chart_of_accounts']);

    // Journal Vouchers
    $routes->get('journal-vouchers', 'Accounting\\JournalVouchers::index', ['filter' => 'permission:accounting.journal_vouchers']);
    $routes->get('journal-vouchers/create', 'Accounting\\JournalVouchers::create', ['filter' => 'permission:accounting.journal_vouchers']);
    $routes->post('journal-vouchers/store', 'Accounting\\JournalVouchers::store', ['filter' => 'permission:accounting.journal_vouchers']);
    // Alias to match menu link
    $routes->get('journal', 'Accounting\\JournalVouchers::index', ['filter' => 'permission:accounting.journal_vouchers']);

    // Bank Deposits
    $routes->get('deposits', 'Accounting\\Deposits::index', ['filter' => 'permission:accounting.bank_deposit']);
    $routes->get('deposits/create', 'Accounting\\Deposits::create', ['filter' => 'permission:accounting.bank_deposit']);
    $routes->post('deposits/store', 'Accounting\\Deposits::store', ['filter' => 'permission:accounting.bank_deposit']);
    
    // VAT / Tax Overview
    $routes->get('vat', 'Accounting\\Vat::index', ['filter' => 'permission:accounting.vat_overview']);

    // Ledger
    $routes->get('ledger', 'Accounting\\Ledger::index', ['filter' => 'permission:accounting.ledger']);
});

// Reports routes
$routes->group('reports', static function ($routes) {
    $routes->get('students', 'Reports::students');
    $routes->get('teachers', 'Reports::teachers');
    $routes->get('payments', 'Reports::payments');
    $routes->get('accounting', 'Reports::accounting');
    $routes->get('deposits', 'Reports::deposits');
    $routes->get('ministry', 'Reports::ministry');
});

// Settings: System pages
$routes->get('settings/language', 'Settings\\SystemController::language');
$routes->post('settings/language', 'Settings\\SystemController::saveLanguage');
$routes->get('settings/school', 'Settings\\SystemController::school');
// HR & Payroll routes
$routes->group('hr', ['filter' => 'permission:dashboard.access'], static function ($routes) {
    $routes->get('employees', 'HR\\Employees::index');
    $routes->get('employees/create', 'HR\\Employees::create');
    $routes->post('employees/store', 'HR\\Employees::store');

    $routes->get('salary-grades', 'HR\\SalaryGrades::index');
    $routes->get('salary-grades/create', 'HR\\SalaryGrades::create');
    $routes->post('salary-grades/store', 'HR\\SalaryGrades::store');

    $routes->get('attendance', 'HR\\Attendance::index');
});

$routes->get('settings/general', 'Settings\\SystemController::general');