<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateSections extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'class_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'name_en' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'name_ar' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('class_id', 'classes', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('sections');
    }

    public function down()
    {
        $this->forge->dropTable('sections');
    }
}
