<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateStudents extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'student_id' => [ 'type' => 'VARCHAR', 'constraint' => 20 ], // YYYY-0000001
            'first_name' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'last_name' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'gender' => [ 'type' => 'ENUM', 'constraint' => ['M','F'], 'null' => true ],
            'dob' => [ 'type' => 'DATE', 'null' => true ],
            'nationality' => [ 'type' => 'VARCHAR', 'constraint' => 100, 'null' => true ],
            'religion' => [ 'type' => 'VARCHAR', 'constraint' => 100, 'null' => true ],
            'parent_name' => [ 'type' => 'VARCHAR', 'constraint' => 150, 'null' => true ],
            'parent_phone' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true ],
            'address' => [ 'type' => 'TEXT', 'null' => true ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('student_id');
        $this->forge->createTable('students');
    }

    public function down()
    {
        $this->forge->dropTable('students');
    }
}
