<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateTeachers extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'first_name' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'last_name' => [ 'type' => 'VARCHAR', 'constraint' => 100 ],
            'email' => [ 'type' => 'VARCHAR', 'constraint' => 150, 'null' => true ],
            'phone' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('teachers');
    }

    public function down()
    {
        $this->forge->dropTable('teachers');
    }
}
