<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEnrollments extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'enrollment_id' => [ 'type' => 'VARCHAR', 'constraint' => 30 ],
            'school_year_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'student_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'class_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'section_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'payment_type_id' => [ 'type' => 'INT', 'unsigned' => true, 'null' => true ],
            'plan' => [ 'type' => 'ENUM', 'constraint' => ['10','4','2','1'], 'default' => '1' ],
            'tuition_total' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('enrollment_id');
        $this->forge->addForeignKey('school_year_id', 'school_years', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('student_id', 'students', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('class_id', 'classes', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('section_id', 'sections', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('payment_type_id', 'payment_types', 'id', 'CASCADE', 'SET NULL');
        $this->forge->createTable('enrollments');
    }

    public function down()
    {
        $this->forge->dropTable('enrollments');
    }
}
