<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateReceipts extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'receipt_no' => [ 'type' => 'VARCHAR', 'constraint' => 30 ],
            'student_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'school_year_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'class_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'section_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'total' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
            'vat' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
            'grand_total' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
            'cr_number' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true ],
            'created_at' => [ 'type' => 'DATETIME', 'null' => true ],
            'updated_at' => [ 'type' => 'DATETIME', 'null' => true ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('receipt_no');
        $this->forge->addForeignKey('student_id', 'students', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('school_year_id', 'school_years', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('class_id', 'classes', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('section_id', 'sections', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('receipts');
    }

    public function down()
    {
        $this->forge->dropTable('receipts');
    }
}
