<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateReceiptItems extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [ 'type' => 'INT', 'unsigned' => true, 'auto_increment' => true ],
            'receipt_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'payment_type_id' => [ 'type' => 'INT', 'unsigned' => true ],
            'description' => [ 'type' => 'VARCHAR', 'constraint' => 150, 'null' => true ],
            'amount' => [ 'type' => 'DECIMAL', 'constraint' => '10,2', 'default' => 0 ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('receipt_id', 'receipts', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('payment_type_id', 'payment_types', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('receipt_items');
    }

    public function down()
    {
        $this->forge->dropTable('receipt_items');
    }
}
