<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterStudentsAddUniqueStudentId extends Migration
{
    public function up()
    {
        // Add unique index to student_id to enforce uniqueness
        $this->db->query('ALTER TABLE `students` ADD UNIQUE KEY `uniq_student_id` (`student_id`)');
    }

    public function down()
    {
        // Drop the unique index
        $this->db->query('ALTER TABLE `students` DROP INDEX `uniq_student_id`');
    }
}
