<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterStudentsAddPhoto extends Migration
{
    public function up()
    {
        // Add photo field to students table
        $this->forge->addColumn('students', [
            'photo' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'address'
            ]
        ]);
    }

    public function down()
    {
        // Remove photo field
        $this->forge->dropColumn('students', 'photo');
    }
}