<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterPaymentTypesAddOption extends Migration
{
    public function up()
    {
        // Add option field to payment_types table
        $this->forge->addColumn('payment_types', [
            'option' => [
                'type' => 'ENUM',
                'constraint' => ['Fixed', 'Optional'],
                'default' => 'Fixed',
                'after' => 'amount'
            ]
        ]);
    }

    public function down()
    {
        // Remove option field
        $this->forge->dropColumn('payment_types', 'option');
    }
}