<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterReceiptsAddVatFields extends Migration
{
    public function up()
    {
        $this->forge->addColumn('receipts', [
            'vat_rate' => [ 'type' => 'DECIMAL', 'constraint' => '5,2', 'default' => 0.15, 'null' => false, 'after' => 'vat' ],
            'vat_number' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true, 'after' => 'cr_number' ],
            'qr_payload' => [ 'type' => 'TEXT', 'null' => true, 'after' => 'vat_number' ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('receipts', 'vat_rate');
        $this->forge->dropColumn('receipts', 'vat_number');
        $this->forge->dropColumn('receipts', 'qr_payload');
    }
}
