<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterStudentsAddParentDetails extends Migration
{
    public function up()
    {
        $this->forge->addColumn('students', [
            'occupation' => [ 'type' => 'VARCHAR', 'constraint' => 150, 'null' => true, 'after' => 'parent_name' ],
            'parent_iqama' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true, 'after' => 'occupation' ],
            'iqama_issue_date' => [ 'type' => 'DATE', 'null' => true, 'after' => 'parent_iqama' ],
            'iqama_expiry_date' => [ 'type' => 'DATE', 'null' => true, 'after' => 'iqama_issue_date' ],
            'place_of_issue' => [ 'type' => 'VARCHAR', 'constraint' => 100, 'null' => true, 'after' => 'iqama_expiry_date' ],
            'company_name' => [ 'type' => 'VARCHAR', 'constraint' => 150, 'null' => true, 'after' => 'place_of_issue' ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('students', 'occupation');
        $this->forge->dropColumn('students', 'parent_iqama');
        $this->forge->dropColumn('students', 'iqama_issue_date');
        $this->forge->dropColumn('students', 'iqama_expiry_date');
        $this->forge->dropColumn('students', 'place_of_issue');
        $this->forge->dropColumn('students', 'company_name');
    }
}
