<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateJournalVouchers extends Migration
{
    public function up()
    {
        // journal_vouchers
        $this->forge->addField([
            'id' => ['type'=>'INT','constraint'=>11,'unsigned'=>true,'auto_increment'=>true],
            'voucher_no' => ['type'=>'VARCHAR','constraint'=>50,'null'=>false],
            'date' => ['type'=>'DATE','null'=>false],
            'description' => ['type'=>'TEXT','null'=>true],
            'created_at' => ['type'=>'DATETIME','null'=>true],
            'updated_at' => ['type'=>'DATETIME','null'=>true],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addUniqueKey('voucher_no');
        $this->forge->createTable('journal_vouchers', true);

        // journal_lines
        $this->forge->addField([
            'id' => ['type'=>'INT','constraint'=>11,'unsigned'=>true,'auto_increment'=>true],
            'voucher_id' => ['type'=>'INT','constraint'=>11,'unsigned'=>true,'null'=>false],
            'account_code' => ['type'=>'VARCHAR','constraint'=>20,'null'=>false],
            'narration' => ['type'=>'VARCHAR','constraint'=>255,'null'=>true],
            'debit' => ['type'=>'DECIMAL','constraint'=>'12,2','default'=>0],
            'credit' => ['type'=>'DECIMAL','constraint'=>'12,2','default'=>0],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('voucher_id');
        $this->forge->createTable('journal_lines', true);
    }

    public function down()
    {
        $this->forge->dropTable('journal_lines', true);
        $this->forge->dropTable('journal_vouchers', true);
    }
}
