<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterStudentsAddMobileAndStudentIqama extends Migration
{
    public function up()
    {
        // Add student mobile and iqama columns if they do not exist
        $fields = [
            'mobile' => [ 'type' => 'VARCHAR', 'constraint' => 20, 'null' => true, 'after' => 'name_ar' ],
            'student_iqama' => [ 'type' => 'VARCHAR', 'constraint' => 50, 'null' => true, 'after' => 'mobile' ],
        ];
        $this->forge->addColumn('students', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('students', 'mobile');
        $this->forge->dropColumn('students', 'student_iqama');
    }
}
