<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        $db = \Config\Database::connect();
        $passwords = service('passwords');

        // Ensure admin user exists
        $user = $db->table('users')->where('username', 'admin')->get()->getRowArray();
        if (! $user) {
            $db->table('users')->insert([
                'username' => 'admin',
                'status' => 'active',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);
            $userId = $db->insertID();

            // Create email/password identity for admin
            $db->table('auth_identities')->insert([
                'user_id'   => $userId,
                'type'      => 'email_password',
                'secret'    => 'admin@example.com',
                'secret2'   => $passwords->hash('Admin@123'),
                'created_at'=> date('Y-m-d H:i:s'),
                'updated_at'=> date('Y-m-d H:i:s'),
            ]);
            // Also create username identity for admin
            $db->table('auth_identities')->insert([
                'user_id'   => $userId,
                'type'      => 'username',
                'secret'    => 'admin',
                'secret2'   => $passwords->hash('Admin@123'),
                'created_at'=> date('Y-m-d H:i:s'),
                'updated_at'=> date('Y-m-d H:i:s'),
            ]);
        } else {
            $userId = $user['id'];
            // Ensure identity exists
            $identity = $db->table('auth_identities')->where(['user_id' => $userId, 'type' => 'email_password'])->get()->getRowArray();
            if (! $identity) {
                $db->table('auth_identities')->insert([
                    'user_id'   => $userId,
                    'type'      => 'email_password',
                    'secret'    => 'admin@example.com',
                    'secret2'   => $passwords->hash('Admin@123'),
                    'created_at'=> date('Y-m-d H:i:s'),
                    'updated_at'=> date('Y-m-d H:i:s'),
                ]);
            }
            // Ensure username identity exists
            $unameIdentity = $db->table('auth_identities')->where(['user_id' => $userId, 'type' => 'username'])->get()->getRowArray();
            if (! $unameIdentity) {
                $db->table('auth_identities')->insert([
                    'user_id'   => $userId,
                    'type'      => 'username',
                    'secret'    => 'admin',
                    'secret2'   => $passwords->hash('Admin@123'),
                    'created_at'=> date('Y-m-d H:i:s'),
                    'updated_at'=> date('Y-m-d H:i:s'),
                ]);
            }
        }

        // Assign user to admin group (Shield stores group name as string)
        $assignment = $db->table('auth_groups_users')->where(['user_id' => $userId, 'group' => 'admin'])->get()->getRowArray();
        if (! $assignment) {
            $db->table('auth_groups_users')->insert([
                'user_id'   => $userId,
                'group'     => 'admin',
                'created_at'=> date('Y-m-d H:i:s'),
            ]);
        }
    }
}
