<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class ClassesSeeder extends Seeder
{
    public function run()
    {
        $now = Time::now('UTC');
        $data = [
            ['name_en' => 'Pre-K', 'name_ar' => 'ما قبل الروضة'],
            ['name_en' => 'Kindergarten', 'name_ar' => 'الروضة'],
            ['name_en' => 'Grade 1', 'name_ar' => 'الصف الأول'],
            ['name_en' => 'Grade 2', 'name_ar' => 'الصف الثاني'],
            ['name_en' => 'Grade 3', 'name_ar' => 'الصف الثالث'],
            ['name_en' => 'Grade 4', 'name_ar' => 'الصف الرابع'],
            ['name_en' => 'Grade 5', 'name_ar' => 'الصف الخامس'],
            ['name_en' => 'Grade 6', 'name_ar' => 'الصف السادس'],
            ['name_en' => 'Grade 7', 'name_ar' => 'الصف السابع'],
            ['name_en' => 'Grade 8', 'name_ar' => 'الصف الثامن'],
            ['name_en' => 'Grade 9', 'name_ar' => 'الصف التاسع'],
            ['name_en' => 'Grade 10', 'name_ar' => 'الصف العاشر'],
            ['name_en' => 'Grade 11', 'name_ar' => 'الصف الحادي عشر'],
            ['name_en' => 'Grade 12', 'name_ar' => 'الصف الثاني عشر'],
        ];

        $builder = $this->db->table('classes');
        foreach ($data as $row) {
            $exists = $builder->where('name_en', $row['name_en'])->get()->getFirstRow();
            if ($exists) {
                continue;
            }
            $row['created_at'] = $now;
            $row['updated_at'] = $now;
            $builder->insert($row);
        }
    }
}