<?php
namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use CodeIgniter\I18n\Time;

class SectionsSeeder extends Seeder
{
    public function run()
    {
        $now = Time::now('UTC');
        
        // Get all classes first
        $classes = $this->db->table('classes')->get()->getResultArray();
        
        if (empty($classes)) {
            return; // No classes to create sections for
        }

        $sectionNames = [
            ['name_en' => 'Section A', 'name_ar' => 'الشعبة أ'],
            ['name_en' => 'Section B', 'name_ar' => 'الشعبة ب'],
            ['name_en' => 'Section C', 'name_ar' => 'الشعبة ج'],
        ];

        $builder = $this->db->table('sections');
        
        foreach ($classes as $class) {
            foreach ($sectionNames as $section) {
                $exists = $builder->where('class_id', $class['id'])
                                ->where('name_en', $section['name_en'])
                                ->get()->getFirstRow();
                if ($exists) {
                    continue;
                }
                
                $data = [
                    'class_id' => $class['id'],
                    'name_en' => $section['name_en'],
                    'name_ar' => $section['name_ar'],
                    'created_at' => $now,
                    'updated_at' => $now,
                ];
                $builder->insert($data);
            }
        }
    }
}