<?= $this->include('layout/header') ?>
<?php $isArabic = (service('language')->getLocale() === 'ar'); ?>
<div class="container my-4" dir="<?= $isArabic ? 'rtl' : 'ltr' ?>">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0"><?= lang('App.bank_deposits') ?></h4>
    <a href="/accounting/deposits/create" class="btn btn-primary">
      <i class="bi bi-plus-lg"></i> <?= $isArabic ? 'إضافة إيداع' : 'New Deposit' ?>
    </a>
  </div>

  <div class="card shadow-sm">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-striped mb-0">
          <thead class="table-light">
            <tr>
              <th><?= $isArabic ? 'رقم الإيداع' : 'Deposit No' ?></th>
              <th><?= lang('App.date') ?></th>
              <th><?= $isArabic ? 'الحساب البنكي' : 'Bank Account' ?></th>
              <th><?= lang('App.amount') ?></th>
              <th><?= lang('App.description') ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($rows)): foreach ($rows as $row): ?>
              <tr>
                <td><?= esc($row['deposit_no'] ?? ('BD-' . (int)$row['id'])) ?></td>
                <td><?= esc($row['date']) ?></td>
                <td><?= esc($row['bank_account_code']) ?></td>
                <td><?= number_format((float)($row['amount'] ?? 0), 2) ?></td>
                <td><?= esc($row['description'] ?? '') ?></td>
              </tr>
            <?php endforeach; else: ?>
              <tr>
                <td colspan="5" class="text-center text-muted py-4">
                  <?= $isArabic ? 'لا توجد إيداعات' : 'No deposits found' ?>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
