<?= $this->include('layout/header') ?>
<?php /** @var array $vouchers */ /** @var string $title */ ?>
<?php $isArabic = (service('language')->getLocale() === 'ar'); ?>
<div class="container py-3" dir="<?= $isArabic ? 'rtl' : 'ltr' ?>">
  <div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="mb-0"><?= esc($title) ?></h5>
      <a href="/accounting/journal-vouchers/create" class="btn btn-primary"><?= lang('App.add') ?></a>
    </div>
    <div class="card-body">
      <?php if (session('success')): ?>
        <div class="alert alert-success mb-3"><?= esc(session('success')) ?></div>
      <?php endif; ?>
      <?php if (session('error')): ?>
        <div class="alert alert-danger mb-3"><?= esc(session('error')) ?></div>
      <?php endif; ?>

      <div class="table-responsive">
        <table class="table table-striped table-bordered">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th><?= $isArabic ? 'رقم القيد' : 'Voucher No' ?></th>
              <th><?= $isArabic ? 'التاريخ' : 'Date' ?></th>
              <th><?= $isArabic ? 'الوصف' : 'Description' ?></th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($vouchers)): foreach ($vouchers as $v): ?>
              <tr>
                <td><?= esc($v['id']) ?></td>
                <td><?= esc($v['voucher_no']) ?></td>
                <td><?= esc($v['date']) ?></td>
                <td><?= esc($v['description'] ?? '') ?></td>
              </tr>
            <?php endforeach; else: ?>
              <tr>
                <td colspan="4" class="text-center text-muted">
                  <?= $isArabic ? 'لا توجد قيود' : 'No vouchers found' ?>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>

