<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <span>Applications</span>
    <div class="ms-auto">
      <a href="/apply" class="btn btn-outline-primary"><i class="bi bi-cloud-arrow-up me-1"></i> Public Apply Form</a>
    </div>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('success')): ?>
      <div class="alert alert-success"><?= esc(session()->getFlashdata('success')) ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <div class="table-responsive">
      <table class="table table-striped table-hover align-middle">
        <thead>
          <tr>
            <th>#</th>
            <th>Registration No</th>
            <th>Name</th>
            <th>Gender</th>
            <th>Program</th>
            <th>Apply Date</th>
            <th>Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        <?php if (empty($applications)): ?>
          <tr><td colspan="8" class="text-center text-muted">No applications yet.</td></tr>
        <?php else: ?>
          <?php foreach ($applications as $i => $a): ?>
          <tr>
            <td><?= $i+1 ?></td>
            <td><span class="text-primary fw-semibold">#<?= esc($a['application_no']) ?></span></td>
            <td><?= esc($a['name_en'] ?? '') ?></td>
            <td><?= esc($a['gender'] ?? '') ?></td>
            <td><?= esc($a['program'] ?? '') ?></td>
            <td><?= esc($a['apply_date'] ?? '') ?></td>
            <td>
              <?php $status = strtolower($a['status'] ?? 'pending');
                $badge = 'secondary';
                if ($status === 'pending') $badge = 'info';
                elseif ($status === 'approved') $badge = 'success';
                elseif ($status === 'rejected') $badge = 'danger';
              ?>
              <span class="badge bg-<?= $badge ?>"><?= esc(ucfirst($status)) ?></span>
            </td>
            <td class="d-flex gap-1">
              <a class="btn btn-sm btn-primary" href="/applications/continue/<?= (int) $a['id'] ?>" title="Continue Registration"><i class="bi bi-arrow-right-circle"></i></a>
              <form method="post" action="/applications/approve/<?= (int) $a['id'] ?>" class="d-inline">
                <?= csrf_field() ?>
                <button class="btn btn-sm btn-success" title="Approve"><i class="bi bi-check"></i></button>
              </form>
              <form method="post" action="/applications/reject/<?= (int) $a['id'] ?>" class="d-inline">
                <?= csrf_field() ?>
                <button class="btn btn-sm btn-warning" title="Reject"><i class="bi bi-x"></i></button>
              </form>
              <form method="post" action="/applications/delete/<?= (int) $a['id'] ?>" class="d-inline" onsubmit="return confirm('Delete application?')">
                <?= csrf_field() ?>
                <button class="btn btn-sm btn-danger" title="Delete"><i class="bi bi-trash"></i></button>
              </form>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
