<!doctype html>
<html lang="<?= $locale ?>" dir="<?= $locale === 'ar' ? 'rtl' : 'ltr' ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login - Jil Alsalam Schools</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <?php if ($locale === 'ar'): ?>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@3.3.4/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
  <?php endif; ?>
  <style>
    body { background: #f6f9fc; }
    .brand-wrapper { text-align: center; padding: 2rem 0 1rem; }
    .brand-logo { height: 250px; max-width: 100%; width: auto; }
    .login-card { max-width: 420px; margin: 1.5rem auto 3rem; }
    .lang-toggle { color: #6c757d; text-decoration: none; }
    .lang-toggle:hover { color: #495057; text-decoration: underline; }
  </style>
</head>
<body>
  <!-- Top Logo -->
  <div class="brand-wrapper">
    <?php
      $logoCandidates = ['assets/logo.png', 'favicon.ico', 'assets/jil-alsalam-logo.png', 'logo.png'];
      $logoSrc = null;
      foreach ($logoCandidates as $p) {
        if (is_file(FCPATH . $p)) { $logoSrc = base_url($p); break; }
      }
    ?>
    <?php if ($logoSrc): ?>
      <img src="<?= $logoSrc ?>" alt="<?= $locale === 'ar' ? 'مدارس جيل السلام' : 'Jil Alsalam Schools' ?>" class="brand-logo" />
    <?php endif; ?>
  </div>

  <!-- Login Card -->
  <div class="login-card card shadow-sm">
    <div class="card-body">
      <div class="text-start d-inline-flex align-items-center gap-2 mb-2 text-muted">
        <i class="bi bi-globe"></i>
        <a class="lang-toggle" href="<?= current_url() . '?lang=' . ($locale === 'ar' ? 'en' : 'ar') ?>">
          <?= $locale === 'ar' ? 'English' : 'العربية' ?>
        </a>
      </div>
      <?php if (session('error')): ?>
        <div class="alert alert-danger"><?= esc(session('error')) ?></div>
      <?php endif; ?>

      <form method="post" action="/login">
        <?= csrf_field() ?>
        <div class="mb-3">
          <label class="form-label"><?= lang('App.email_address') ?> / <?= lang('App.username') ?></label>
          <input type="text" class="form-control" name="login" placeholder="admin@email.com" required />
        </div>
        <div class="mb-3">
          <label class="form-label"><?= lang('App.password') ?></label>
          <input type="password" class="form-control" name="password" placeholder="<?= $locale === 'ar' ? 'أدخل كلمة المرور' : 'Enter your password' ?>" required />
        </div>
        <button type="submit" class="btn btn-primary w-100"><?= lang('App.sign_in') ?></button>
      </form>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>