<?= $this->include('layout/header') ?>
<?php $isArabic = (service('language')->getLocale() === 'ar'); ?>
<style>
  @page { size: A4; margin: 16mm; }
  @media print {
    nav, aside, .btn, .no-print { display: none !important; }
    .print-sheet { box-shadow: none; border: none; padding: 0; }
  }
  .sheet-header { display:flex; align-items:center; justify-content:space-between; gap:16px; margin-bottom:12px; }
  .brand { display:flex; align-items:center; gap:10px; }
  .brand img { width:40px; height:40px; }
  .brand .school { font-size:1.2rem; font-weight:600; }
  .meta div { line-height:1.4; }
  .section-title { font-weight:600; margin:12px 0 8px; }
  .kv { display:flex; gap:8px; }
  .kv .k { width:180px; color:#6c757d; }
  .photo { width:90px; height:90px; object-fit:cover; border-radius:6px; border:1px solid #ddd; }
</style>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-file-text me-2"></i> <?= lang('App.registration') ?>
    <a href="/enrollment" class="btn btn-sm btn-outline-secondary ms-auto no-print"><i class="bi bi-arrow-left"></i> <?= lang('App.back') ?></a>
    <button class="btn btn-sm btn-primary ms-2 no-print" onclick="window.print()"><i class="bi bi-printer"></i> <?= lang('App.print') ?></button>
  </div>
  <div class="card-body print-sheet">
    <?php if (session('success')): ?>
      <div class="alert alert-success no-print"><?= esc(session('success')) ?></div>
    <?php endif; ?>

    <?php $schoolName = 'JAS International School'; ?>
    <div class="sheet-header">
      <div class="brand">
        <img src="<?= base_url('favicon.ico') ?>" alt="School Logo" />
        <div class="school"><?= esc($schoolName) ?></div>
      </div>
      <div class="meta">
        <div><strong><?= lang('App.registration') ?> #:</strong> <?= esc($enrollment['enrollment_id'] ?? '') ?></div>
        <div><strong><?= lang('App.date') ?>:</strong> <?= esc(date('Y-m-d H:i')) ?></div>
      </div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="section-title"><?= lang('App.student_information') ?></div>
          <div class="d-flex align-items-center mb-2">
            <?php $photo = $student['photo'] ?? null; $photoUrl = $photo ? base_url('photos/' . basename($photo)) : null; ?>
            <?php if ($photoUrl): ?>
              <img class="photo me-3" src="<?= esc($photoUrl) ?>" alt="Student Photo" />
            <?php endif; ?>
            <div>
              <div class="kv"><div class="k"><?= lang('App.student_id') ?>:</div><div><strong><?= esc($student['student_id'] ?? '') ?></strong></div></div>
              <div class="kv"><div class="k"><?= lang('App.student_name_en') ?>:</div><div><?= esc(trim(($student['first_name'] ?? '') . ' ' . ($student['last_name'] ?? ''))) ?></div></div>
              <div class="kv"><div class="k"><?= lang('App.student_name_ar') ?>:</div><div><?= esc($student['name_ar'] ?? '') ?></div></div>
            </div>
          </div>
          <div class="kv"><div class="k"><?= lang('App.gender') ?>:</div><div><?= esc((($student['gender'] ?? null) === 'F') ? lang('App.female') : (($student['gender'] ?? null) === 'M' ? lang('App.male') : '')) ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.birth_date_g') ?>:</div><div><?= esc($student['dob'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.nationality') ?>:</div><div><?= esc($student['nationality'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.religion') ?>:</div><div><?= esc($student['religion'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.home_address') ?>:</div><div><?= esc($student['address'] ?? '') ?></div></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="section-title"><?= lang('App.parent_information') ?></div>
          <div class="kv"><div class="k"><?= lang('App.father_name') ?>:</div><div><?= esc($student['parent_name'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.telephone_number') ?>:</div><div><?= esc($student['parent_phone'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.occupation') ?>:</div><div><?= esc($student['occupation'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.iqama_number') ?>:</div><div><?= esc($student['parent_iqama'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.iqama_issue_date') ?>:</div><div><?= esc($student['iqama_issue_date'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.iqama_expiry_date') ?>:</div><div><?= esc($student['iqama_expiry_date'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.place_of_issue') ?>:</div><div><?= esc($student['place_of_issue'] ?? '') ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.company_name') ?>:</div><div><?= esc($student['company_name'] ?? '') ?></div></div>
        </div>
      </div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="section-title"><?= lang('App.academic_information') ?></div>
          <div class="kv"><div class="k"><?= lang('App.school_year') ?>:</div><div><?= esc($schoolYear['school_year'] ?? ($enrollment['school_year_id'] ?? '')) ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.class') ?>:</div><div><?= esc($isArabic ? ($class['name_ar'] ?? $class['name_en'] ?? '') : ($class['name_en'] ?? $class['name_ar'] ?? '')) ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.section') ?>:</div><div><?= esc($isArabic ? ($section['name_ar'] ?? $section['name_en'] ?? '') : ($section['name_en'] ?? $section['name_ar'] ?? '')) ?></div></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="section-title"><?= lang('App.payments') ?></div>
          <div class="kv"><div class="k"><?= lang('App.payment_type') ?>:</div><div><?= esc($isArabic ? ($paymentType['description_ar'] ?? $paymentType['description_en'] ?? '') : ($paymentType['description_en'] ?? $paymentType['description_ar'] ?? '')) ?></div></div>
          <div class="kv"><div class="k"><?= lang('App.plan') ?>:</div><div><?= esc(($enrollment['plan'] ?? '')) ?> <?= lang('App.installments') ?></div></div>
        </div>
      </div>
    </div>

    <div class="border rounded p-3">
      <div class="section-title"><?= lang('App.description') ?></div>
      <div class="text-muted">—</div>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
