<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-badge-vr me-2"></i> <?= esc($title ?? 'Salary Grades') ?> - Add
    <a href="/hr/salary-grades" class="btn btn-outline-secondary btn-sm ms-auto">
      <i class="bi bi-arrow-left me-1"></i> Back
    </a>
  </div>
  <div class="card-body">
    <?php if (session()->getFlashdata('error')): ?>
      <div class="alert alert-danger"><?= esc(session()->getFlashdata('error')) ?></div>
    <?php endif; ?>

    <form action="/hr/salary-grades/store" method="post">
      <?= csrf_field() ?>
      <div class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" required>
        </div>
        <div class="col-md-5">
          <label class="form-label">Name</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Base Salary</label>
          <input type="number" step="0.01" name="base_salary" class="form-control" value="0.00" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Currency</label>
          <input type="text" name="currency" class="form-control" value="SAR" maxlength="3">
        </div>
      </div>
      <div class="mt-3">
        <button type="submit" class="btn btn-primary"><i class="bi bi-save me-1"></i> <?= lang('App.save') ?></button>
        <a href="/hr/salary-grades" class="btn btn-secondary ms-2"><i class="bi bi-x-circle me-1"></i> <?= lang('App.cancel') ?></a>
      </div>
    </form>
  </div>
</div>
<?= $this->include('layout/footer') ?>
