<?php
$req = service('request');
$langParam = $req->getGet('lang');
if ($langParam && in_array($langParam, ['en','ar'])) { session()->set('app_locale', $langParam); }
$locale = session('app_locale') ?? 'en';
// Ensure language locale is set before any lang() calls in the header
\Config\Services::language()->setLocale($locale);
?>
<!doctype html>
<html lang="<?= $locale ?>" dir="<?= $locale === 'ar' ? 'rtl' : 'ltr' ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'School JAS') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
  <?php if ((session('app_locale') ?? 'en') === 'ar'): ?>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@3.3.4/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
  <?php endif; ?>
  <style>
    .brand-logo { max-height: 80px; }
    .sidebar { min-height: 70vh; }
  </style>
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand" href="/dashboard"><?= lang('App.jil_alsalam_schools') ?></a>
    <div class="d-flex ms-auto align-items-center gap-2">
      <?php if (($locale ?? 'en') === 'en'): ?>
        <a class="btn btn-outline-light d-flex align-items-center gap-1" href="?lang=ar"><i class="bi bi-globe2"></i> العربية</a>
      <?php else: ?>
        <a class="btn btn-outline-light d-flex align-items-center gap-1" href="?lang=en"><i class="bi bi-globe2"></i> English</a>
      <?php endif; ?>
      <span class="text-light small">admin@email.com</span>
      <a class="btn btn-light" href="/logout"><?= lang('App.logout') ?></a>
    </div>
  </div>
</nav>
<div class="container my-4">
<?php
  $isAr = $locale === 'ar';
  $asideClass = $isAr ? 'col-lg-3 order-lg-2' : 'col-lg-3';
  $mainClass  = $isAr ? 'col-lg-9 order-lg-1' : 'col-lg-9';
  $segment = service('uri')->getSegment(1) ?? 'dashboard';
  $showSetup = in_array($segment, ['setup','teachers']);
  $showStudents = $segment === 'students' || $segment === 'enrollment';
  $showPayments = in_array($segment, ['payments','receipts']);
  $showAccounting = $segment === 'accounting';
  $showHRPayroll = in_array($segment, ['hr','payroll']);
  $showReports = $segment === 'reports';
  $showSettings = $segment === 'settings';
?>
  <div class="row g-4 <?= $isAr ? 'flex-row-reverse' : '' ?>">
    <aside class="<?= $asideClass ?>">
      <div class="sidebar card">
        <!-- Quick action buttons removed per request -->
        <div class="list-group list-group-flush">
          <!-- Dashboard -->
          <a href="/dashboard" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'dashboard' ? 'active' : '' ?>">
            <i class="bi bi-speedometer2 me-2"></i> <?= lang('App.dashboard') ?>
          </a>

          <!-- Enrollment / Registration -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuEnrollment" role="button" aria-expanded="<?= $showStudents ? 'true' : 'false' ?>" aria-controls="menuEnrollment">
            <i class="bi bi-person-plus me-2"></i> <?= lang('App.enrollment') ?> / <?= lang('App.registration') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showStudents ? 'show' : '' ?>" id="menuEnrollment">
            <a href="/enrollment" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'enrollment' ? 'active' : '' ?>">
              <i class="bi bi-person-plus me-2"></i> <?= lang('App.enroll_student') ?>
            </a>
            <a href="/applications" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'applications' ? 'active' : '' ?>">
              <i class="bi bi-ui-checks-grid me-2"></i> <?= esc(lang('App.applications') ?? 'Applications') ?>
            </a>
          </div>

          <!-- Maintenance / Setup -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuSetup" role="button" aria-expanded="<?= $showSetup ? 'true' : 'false' ?>" aria-controls="menuSetup">
            <i class="bi bi-tools me-2"></i> <?= lang('App.maintenance') ?> / <?= lang('App.setup') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showSetup ? 'show' : '' ?>" id="menuSetup">
            <a href="/setup/school-years" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-calendar3 me-2"></i> <?= lang('App.school_year') ?>
            </a>
            <a href="/setup/classes" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-building me-2"></i> <?= lang('App.classes') ?>
            </a>
            <a href="/setup/sections" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-diagram-3 me-2"></i> <?= lang('App.sections') ?>
            </a>
            <a href="/setup/payment-types" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-wallet2 me-2"></i> <?= lang('App.payment_types') ?>
            </a>
            <a href="/setup/nationalities" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-flag me-2"></i> <?= lang('App.nationalities') ?>
            </a>
            <a href="/setup/religions" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'setup') ? 'active' : '' ?>">
              <i class="bi bi-peace me-2"></i> <?= lang('App.religion') ?>
            </a>
            <a href="/teachers" class="list-group-item list-group-item-action d-flex align-items-center <?= ($segment === 'teachers') ? 'active' : '' ?>">
              <i class="bi bi-mortarboard me-2"></i> <?= lang('App.teachers') ?>
            </a>
          </div>

          <!-- Students -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuStudents" role="button" aria-expanded="<?= $showStudents ? 'true' : 'false' ?>" aria-controls="menuStudents">
            <i class="bi bi-people me-2"></i> <?= lang('App.students') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showStudents ? 'show' : '' ?>" id="menuStudents">
            <a href="/students" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'students' ? 'active' : '' ?>">
              <i class="bi bi-list-ul me-2"></i> <?= lang('App.student_list') ?>
            </a>
            <a href="/students/profile" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-person-lines-fill me-2"></i> <?= lang('App.student_profile') ?>
            </a>
          </div>

          <!-- Payments / Billing -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuPayments" role="button" aria-expanded="<?= $showPayments ? 'true' : 'false' ?>" aria-controls="menuPayments">
            <i class="bi bi-receipt-cutoff me-2"></i> <?= lang('App.payments') ?> / <?= lang('App.billing') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showPayments ? 'show' : '' ?>" id="menuPayments">
            <a href="/payments" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'payments' ? 'active' : '' ?>">
              <i class="bi bi-receipt me-2"></i> <?= lang('App.payment_receipts') ?>
            </a>
            <a href="/payments/history" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-clock-history me-2"></i> <?= lang('App.receipt_history') ?>
            </a>
            <a href="/payments/pending" class="list-group-item list-group-item-action d-flex align-items-center <?= $segment === 'receipts' ? 'active' : '' ?>">
              <i class="bi bi-hourglass-split me-2"></i> <?= lang('App.pending_payments') ?>
            </a>
            <a href="/payments/installments" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-calendar2-check me-2"></i> <?= lang('App.installments_management') ?>
            </a>
          </div>

          <!-- Accounting -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuAccounting" role="button" aria-expanded="<?= $showAccounting ? 'true' : 'false' ?>" aria-controls="menuAccounting">
            <i class="bi bi-calculator me-2"></i> <?= lang('App.accounting') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showAccounting ? 'show' : '' ?>" id="menuAccounting">
            <a href="/accounting/accounts" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-diagram-3 me-2"></i> <?= lang('App.chart_of_accounts') ?>
            </a>
            <a href="/accounting/journal" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-journal-text me-2"></i> <?= lang('App.journal_vouchers') ?>
            </a>
            <a href="/accounting/ledger" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-grid-3x3-gap me-2"></i> <?= lang('App.ledger') ?>
            </a>
            <a href="/accounting/deposits" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-bank me-2"></i> <?= lang('App.bank_deposits') ?>
            </a>
            <a href="/accounting/vat" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-percent me-2"></i> <?= lang('App.vat_tax_overview') ?>
            </a>
          </div>

          <!-- HR & Payroll -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuHRPayroll" role="button" aria-expanded="<?= $showHRPayroll ? 'true' : 'false' ?>" aria-controls="menuHRPayroll">
            <i class="bi bi-person-badge me-2"></i> <?= lang('App.hr_and_payroll') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showHRPayroll ? 'show' : '' ?>" id="menuHRPayroll">
            <!-- HR -->
            <a href="/hr/employees" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-people-fill me-2"></i> <?= lang('App.employees') ?>
            </a>
            <a href="/hr/attendance" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-calendar-check me-2"></i> <?= lang('App.attendance') ?>
            </a>
            <a href="/hr/leave" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-calendar-minus me-2"></i> <?= lang('App.leave_management') ?>
            </a>
            <a href="/hr/contracts" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-file-earmark-text me-2"></i> <?= lang('App.contracts') ?>
            </a>
            <!-- Payroll -->
            <a href="/payroll/runs" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-cash-stack me-2"></i> <?= lang('App.payroll_runs') ?>
            </a>
            <a href="/payroll/payslips" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-receipt me-2"></i> <?= lang('App.payslips') ?>
            </a>
            <a href="/payroll/salary-grades" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-bar-chart me-2"></i> <?= lang('App.salary_grades') ?>
            </a>
            <a href="/payroll/deductions" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-dash-circle me-2"></i> <?= lang('App.deductions') ?>
            </a>
            <a href="/payroll/benefits" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-gift me-2"></i> <?= lang('App.benefits') ?>
            </a>
          </div>

          <!-- Reports -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuReports" role="button" aria-expanded="<?= $showReports ? 'true' : 'false' ?>" aria-controls="menuReports">
            <i class="bi bi-graph-up me-2"></i> <?= lang('App.reports') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showReports ? 'show' : '' ?>" id="menuReports">
            <a href="/reports/students" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-people me-2"></i> <?= lang('App.students_reports') ?>
            </a>
            <a href="/reports/teachers" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-mortarboard me-2"></i> <?= lang('App.teachers_report') ?>
            </a>
            <a href="/reports/payments" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-cash-stack me-2"></i> <?= lang('App.payments_reports') ?>
            </a>
            <a href="/reports/accounting" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-journal me-2"></i> <?= lang('App.accounting_reports') ?>
            </a>
            <a href="/reports/deposits" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-bank2 me-2"></i> <?= lang('App.bank_deposits_reports') ?>
            </a>
            <a href="/reports/ministry" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-file-earmark-spreadsheet me-2"></i> <?= lang('App.ministry_reports') ?>
            </a>
          </div>

          <!-- Settings / System -->
          <a class="list-group-item d-flex align-items-center" data-bs-toggle="collapse" href="#menuSettings" role="button" aria-expanded="<?= $showSettings ? 'true' : 'false' ?>" aria-controls="menuSettings">
            <i class="bi bi-sliders me-2"></i> <?= lang('App.settings') ?> / <?= lang('App.system') ?>
            <i class="bi bi-caret-down ms-auto"></i>
          </a>
          <div class="collapse <?= $showSettings ? 'show' : '' ?>" id="menuSettings">
            <?php if (function_exists('auth') && auth()->loggedIn() && auth()->user()->inGroup('admin')): ?>
            <a href="/settings/users" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-people me-2"></i> <?= lang('App.user_management') ?>
            </a>
            <?php endif; ?>
            <a href="/settings/language" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-translate me-2"></i> <?= lang('App.language_settings') ?>
            </a>
            <a href="/settings/school" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-building me-2"></i> <?= lang('App.school_info') ?>
            </a>
            <a href="/settings/general" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-gear me-2"></i> <?= lang('App.general_settings') ?>
            </a>
            <a href="/settings/vat" class="list-group-item list-group-item-action d-flex align-items-center">
              <i class="bi bi-percent me-2"></i> <?= lang('App.vat_settings') ?>
            </a>
          </div>

          <!-- Logout -->
          <a href="/logout" class="list-group-item list-group-item-action d-flex align-items-center">
            <i class="bi bi-box-arrow-right me-2"></i> <?= lang('App.logout') ?>
          </a>
        </div>
      </div>
      <script>
         document.addEventListener('DOMContentLoaded', function () {
           function toTitleCase(s) {
             return s.replace(/\w\S*/g, function(w){ return w.charAt(0).toUpperCase() + w.slice(1).toLowerCase(); });
           }
           function prettifyText(s) {
             let out = s.replace(/App\./g, '');
             if (/[_]/.test(out)) {
               out = out.replace(/_/g, ' ');
             }
             if (/^[\x00-\x7F]+$/.test(out)) {
               out = toTitleCase(out);
             }
             return out;
           }
           document.querySelectorAll('.sidebar .list-group-item, .metric-card .small, .navbar .btn, .card .card-header, .card .list-group-item').forEach(function (el) {
             el.childNodes.forEach(function (n) {
               if (n.nodeType === Node.TEXT_NODE) {
                 const trimmed = n.textContent.trim();
                 if (trimmed.includes('App.') || /[A-Za-z]_[A-Za-z]/.test(trimmed)) {
                   n.textContent = prettifyText(n.textContent);
                 }
               }
             });
           });
         });
       </script>
    </aside>
    <main class="<?= $mainClass ?>">

