<?= $this->include('layout/header') ?>
<style>
  /* A4 Portrait print size with comfortable margins */
  @page { size: A4; margin: 10mm; }
  html, body { height: 100%; }
  @media print {
    html, body { width: 210mm; height: 297mm; }
    .navbar, .sidebar, .card-header, .alert, .print-actions { display: none !important; }
    .card { border: none; box-shadow: none; }
    .print-sheet { width: 210mm; min-height: 297mm; margin: 0; padding: 0; transform-origin: top left; page-break-inside: avoid; }
  }
  .print-container { max-width: 100%; }
  .print-sheet { width: 210mm; min-height: 297mm; margin: 0 auto; }
  .receipt-header { display: flex; align-items: center; justify-content: space-between; border-bottom: 1px solid #ddd; padding: 6px 0; margin-bottom: 8px; page-break-inside: avoid; }
  .receipt-brand { display: flex; align-items: center; gap: 10px; }
  .receipt-brand img { height: 36px; width: auto; }
  .receipt-school { font-size: 16px; font-weight: 600; }
  .receipt-meta { text-align: right; font-size: 12px; }
  .table { font-size: 12px; page-break-inside: avoid; }
  .table td, .table th { padding: .3rem; }
  .print-sheet .row { --bs-gutter-x: .6rem; --bs-gutter-y: .35rem; }

</style>
<div class="card print-container">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-printer me-2"></i> <?= lang('App.printable_receipt') ?> <?= esc($receipt['receipt_no'] ?? '') ?>
    <a href="/payments" class="btn btn-sm btn-outline-secondary ms-auto"><i class="bi bi-arrow-left"></i> <?= lang('App.back') ?></a>
  </div>
  <div class="card-body print-sheet">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php endif; ?>

    <?php $schoolName = trim((string)($settings['school_name'] ?? '')); if ($schoolName==='') { $schoolName = 'JAS International School'; } ?>
    <?php $logoPath = !empty($settings['logo_path']) ? base_url('writable/' . $settings['logo_path']) : base_url('favicon.ico'); ?>
    <div class="receipt-header">
      <div class="receipt-brand">
        <img src="<?= esc($logoPath) ?>" alt="School Logo" />
        <div class="receipt-school"><?= esc($schoolName) ?></div>
      </div>
      <div class="receipt-meta">
        <div class="fw-bold"><?= lang('App.tax_invoice') ?></div>
        <div><strong><?= lang('App.receipt_no') ?>:</strong> <?= esc($receipt['receipt_no'] ?? '') ?></div>
        <div><strong><?= lang('App.cr_number') ?>:</strong> <?= esc($receipt['cr_number'] ?? '-') ?></div>
        <div><strong><?= lang('App.vat_number') ?>:</strong> <?= esc($receipt['vat_number'] ?? '-') ?></div>
        <div><strong><?= lang('App.date') ?>:</strong> <?= esc(date('Y-m-d H:i')) ?></div>
      </div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="fw-bold mb-2"><?= lang('App.student') ?></div>
          <div><strong><?= esc($student['student_id'] ?? '') ?></strong></div>
          <div><?= esc(($student['first_name'] ?? '') . ' ' . ($student['last_name'] ?? '')) ?></div>
          <div class="text-muted"><?= lang('App.parent') ?>: <?= esc($student['parent_phone'] ?? '') ?></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="fw-bold mb-2">QR</div>
          <?php if (!empty($receipt['qr_payload'])): ?>
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=160x160&data=<?= rawurlencode($receipt['qr_payload'] ?? '') ?>" alt="QR Code" />
          <?php else: ?>
            <div class="text-muted">QR code unavailable.</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="border rounded p-3">
          <div class="fw-bold mb-2"><?= lang('App.summary') ?></div>
          <div><?= lang('App.payment_method') ?>: <strong><?= esc(lang('App.' . strtolower($receipt['payment_method'] ?? 'cash'))) ?></strong></div>
          <div><?= lang('App.total') ?>: <strong><?= esc(number_format((float)($receipt['total'] ?? 0), 2)) ?></strong></div>
          <div><?= 'VAT (' . esc(number_format((float)($receipt['vat_rate'] ?? 0.15) * 100, 0)) . '%)' ?>: <?= esc(number_format((float)($receipt['vat'] ?? 0), 2)) ?></div>
          <div><?= lang('App.total_with_vat') ?>: <strong><?= esc(number_format((float)($receipt['grand_total'] ?? 0), 2)) ?></strong></div>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered">
        <thead>
          <tr>
            <th>#</th>
            <th><?= lang('App.description') ?></th>
            <th class="text-end"><?= lang('App.amount') ?></th>
          </tr>
        </thead>
        <tbody>
          <?php $i=1; foreach (($items ?? []) as $it): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= esc($it['description'] ?? '') ?></td>
              <td class="text-end"><?= esc(number_format((float)($it['amount'] ?? 0), 2)) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
        <tfoot>
          <tr>
            <th colspan="2" class="text-end"><?= lang('App.total') ?></th>
            <th class="text-end"><?= esc(number_format((float)($receipt['total'] ?? 0), 2)) ?></th>
          </tr>
          <tr>
            <th colspan="2" class="text-end"><?= 'VAT (' . esc(number_format((float)($receipt['vat_rate'] ?? 0.15) * 100, 0)) . '%)' ?></th>
            <th class="text-end"><?= esc(number_format((float)($receipt['vat'] ?? 0), 2)) ?></th>
          </tr>
          <tr>
            <th colspan="2" class="text-end"><?= lang('App.total_with_vat') ?></th>
            <th class="text-end"><?= esc(number_format((float)($receipt['grand_total'] ?? 0), 2)) ?></th>
          </tr>
        </tfoot>
      </table>
    </div>

    <div class="mt-3 print-actions">
      <button class="btn btn-primary" onclick="window.print()"><i class="bi bi-printer"></i> <?= lang('App.print') ?></button>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>