<?= $this->include('layout/header') ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h5 class="mb-0"><?= lang('App.user_management') ?></h5>
  <a href="/settings/users/create" class="btn btn-primary btn-sm"><i class="bi bi-plus"></i> <?= lang('App.add') ?> User</a>
</div>

<?php if (session()->getFlashdata('success')): ?>
  <div class="alert alert-success py-2"><?= esc(session()->getFlashdata('success')) ?></div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')): ?>
  <div class="alert alert-danger py-2"><?= esc(session()->getFlashdata('error')) ?></div>
<?php endif; ?>

<div class="table-responsive">
  <table class="table table-sm table-striped align-middle">
    <thead>
      <tr>
        <th style="width:70px;">ID</th>
        <th>Username</th>
        <th>Email</th>
        <th style="width:140px;">Group</th>
        <th style="width:110px;">Status</th>
        <th style="width:280px;"></th>
      </tr>
    </thead>
    <tbody>
      <?php foreach (($users ?? []) as $u): ?>
        <tr>
          <td><?= esc($u['id'] ?? '') ?></td>
          <td><?= esc($u['username'] ?? ($u['uname'] ?? '')) ?></td>
          <td><?= esc($u['email'] ?? '') ?></td>
          <td><?= esc($u['group_name'] ?? '') ?></td>
          <td>
            <?php if (($u['status'] ?? '') === 'inactive'): ?>
              <span class="badge bg-secondary">Inactive</span>
            <?php else: ?>
              <span class="badge bg-success">Active</span>
            <?php endif; ?>
          </td>
          <td class="text-end">
            <a href="/settings/users/edit/<?= (int)($u['id'] ?? 0) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
            <form method="post" action="/settings/users/deactivate/<?= (int)($u['id'] ?? 0) ?>" class="d-inline">
              <button type="submit" class="btn btn-sm btn-outline-warning">Deactivate</button>
            </form>
            <a href="/settings/users/permissions/<?= (int)($u['id'] ?? 0) ?>" class="btn btn-sm btn-outline-secondary">Permissions</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?= $this->include('layout/footer') ?>

