<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-wallet2 me-2"></i> Payment Types
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/setup/payment-types" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-4">
        <label class="form-label">Description (EN)</label>
        <input type="text" name="description_en" class="form-control" required />
      </div>
      <div class="col-md-4">
        <label class="form-label">Description (AR)</label>
        <input type="text" name="description_ar" class="form-control" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Amount</label>
        <input type="number" step="0.01" name="amount" class="form-control" value="0" />
      </div>
      <div class="col-md-2">
        <label class="form-label">Option</label>
        <select name="option" class="form-control" required>
          <option value="Fixed">Fixed</option>
          <option value="Optional">Optional</option>
        </select>
      </div>
      <div class="col-md-1 d-flex align-items-end">
        <button class="btn btn-primary w-100" type="submit">Add</button>
      </div>
    </form>

    <hr />
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Description (EN)</th>
            <th>Description (AR)</th>
            <th>Amount</th>
            <th>Option</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($items as $row): ?>
          <tr>
            <td><?= esc($row['id'] ?? '') ?></td>
            <td><?= esc($row['description_en'] ?? '') ?></td>
            <td><?= esc($row['description_ar'] ?? '') ?></td>
            <td><?= esc($row['amount'] ?? '0.00') ?></td>
            <td>
              <span class="badge <?= ($row['option'] ?? 'Fixed') === 'Fixed' ? 'bg-primary' : 'bg-secondary' ?>">
                <?= esc($row['option'] ?? 'Fixed') ?>
              </span>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (! $items): ?>
          <tr><td colspan="5" class="text-center text-muted">No entries yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
