<?= $this->include('layout/header') ?>
<div class="card">
  <div class="card-header d-flex align-items-center">
    <i class="bi bi-diagram-3 me-2"></i> Sections
  </div>
  <div class="card-body">
    <?php if (session('success')): ?>
      <div class="alert alert-success"><?= esc(session('success')) ?></div>
    <?php elseif (session('error')): ?>
      <div class="alert alert-danger"><?= esc(session('error')) ?></div>
    <?php endif; ?>

    <form method="post" action="/setup/sections" class="row g-3">
      <?= csrf_field() ?>
      <div class="col-md-4">
        <label class="form-label">Class</label>
        <select name="class_id" class="form-select" required>
          <option value="">Select class</option>
          <?php foreach ($classes as $c): ?>
            <option value="<?= esc($c['id']) ?>"><?= esc($c['name_en']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Name (EN)</label>
        <input type="text" name="name_en" class="form-control" required />
      </div>
      <div class="col-md-3">
        <label class="form-label">Name (AR)</label>
        <input type="text" name="name_ar" class="form-control" />
      </div>
      <div class="col-md-1 d-flex align-items-end">
        <button class="btn btn-primary w-100" type="submit">Add</button>
      </div>
    </form>

    <hr />
    <div class="table-responsive">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th>Class</th>
            <th>Name (EN)</th>
            <th>Name (AR)</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($items as $row): ?>
          <tr>
            <td><?= esc($row['id'] ?? '') ?></td>
            <td><?= esc($row['class_name'] ?? '') ?></td>
            <td><?= esc($row['name_en'] ?? '') ?></td>
            <td><?= esc($row['name_ar'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (! $items): ?>
          <tr><td colspan="4" class="text-center text-muted">No entries yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?= $this->include('layout/footer') ?>
