<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title><?= esc($title) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" />
  <style>
    @media print {
      .no-print { display: none !important; }
      table { page-break-inside: auto; }
      tr { page-break-inside: avoid; page-break-after: auto; }
    }
  </style>
</head>
<body>
  <div class="container py-3">
    <div class="d-flex justify-content-between align-items-center no-print">
      <h4 class="mb-0"><?= lang('App.students') ?> (<?= (int) ($totalFiltered ?? 0) ?>)</h4>
      <div class="d-flex gap-2">
-        <a href="<?= site_url('students') . '?' . http_build_query($filters ?? []) ?>" class="btn btn-secondary"><?= lang('App.back') ?></a>
+        <a href="<?= site_url('students') . '?' . http_build_query(array_merge(($filters ?? []), ['lang' => service('request')->getLocale()])) ?>" class="btn btn-secondary"><?= lang('App.back') ?></a>
        <button onclick="window.print()" class="btn btn-dark"><?= lang('App.print') ?></button>
      </div>
    </div>

    <hr class="no-print" />

    <table class="table table-sm table-bordered">
      <thead>
        <tr>
          <th><?= lang('App.student_no') ?></th>
          <th><?= lang('App.first_name') ?></th>
          <th><?= lang('App.last_name') ?></th>
          <th><?= lang('App.gender') ?></th>
          <th><?= lang('App.class') ?></th>
          <th><?= lang('App.section') ?></th>
          <th><?= lang('App.nationality') ?></th>
          <th><?= lang('App.religion') ?></th>
          <th><?= lang('App.parent_name') ?></th>
          <th><?= lang('App.parent_phone') ?></th>
          <th><?= lang('App.address') ?></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach (($students ?? []) as $st): ?>
        <tr>
          <td><?= esc($st['student_id'] ?? '') ?></td>
          <td><?= esc($st['first_name'] ?? '') ?></td>
          <td><?= esc($st['last_name'] ?? '') ?></td>
          <td><?= (($st['gender'] ?? '') === 'F') ? lang('App.female') : ((($st['gender'] ?? '') === 'M') ? lang('App.male') : '') ?></td>
          <td><?= esc($st['class_name'] ?? '') ?></td>
          <td><?= esc($st['section_name'] ?? '') ?></td>
          <td><?= esc($st['nationality'] ?? '') ?></td>
          <td><?= esc($st['religion'] ?? '') ?></td>
          <td><?= esc($st['parent_name'] ?? '') ?></td>
          <td><?= esc($st['parent_phone'] ?? '') ?></td>
          <td><?= esc($st['address'] ?? '') ?></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>